<?php
function transform() {
    
    if ( !isset($_REQUEST["xml"]) ) {
        echo "<h3>Must enter an XML string!</h3>";
        return;
    }

    $xmlstr = stripslashes($_REQUEST["xml"]);

    $xml = new DomDocument; // from /ext/dom
    $xml->loadXML($xmlstr);
    
    $xsl = new DomDocument;
    $xsl->load("dbd2propel.xsl");
    
    $proc = new XSLTProcessor;
    $proc->importStyleSheet($xsl); // attach the xsl rules
    $xmlstr = $proc->transformToXML($xml);
    
    $res = "<p class=\"strong\">Propel Schema XML:</p>";
    $res .= "<hr><textarea style=\"font-size:9pt\" cols=\"100\" rows=\"20\">";
    $res .= htmlentities(mise_en_forme_phpName($xmlstr));
    $res .= "</textarea><hr>";
	
	return $res;
}

function mise_en_forme_phpName($xml)
{
	$pattern = '/phpName="([^"]*)"/';
	return preg_replace_callback($pattern, 'strToCamelCase', $xml);
}

function strToCamelCase($matches)
{
	$string = $matches[1];
	// Merci pour le code à SMARTY
	$string = ucwords(preg_replace("/(\_(.))/e","strtoupper('\\2')",strtolower($string)));

    return str_replace($matches[1], $string, $matches[0]);
}

if (isset($_POST['submit'])) {
	$res = transform();
} else {
	$res = '';
}
?>
<html>
	<head>
		<title>Outil de transformation de XML pour Symfony</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" >
		<style>
			.strong {
				font-weight: bold;
			}
		</style>
	</head>
	<body>
		<h1>Outil de transformation de XML pour Symfony</h1>
		<p>Cet outil permet de transformer les bases de données au format DBDesigner4 dans le format compréhensible par Symfony</p>
		<?php echo $res; ?>
		<p class="strong">Copier le contenu du fichier XML de DBDesigner4 ci dessous:</p>
		<form action="transform_xml.php" method="post">
			<textarea name="xml" cols="100" rows="20"></textarea>
			<br />
			<input type="submit" name="submit" value="Convertir" />
		</form>
	</body>
</html>