<?php
/**
 * Classe de gestion des applications portables
 *
 * Cette classe permet de gérer tout ce qui concerne les applications
 * portables dans leur généralité, c'est à dire sans rapport avec les releases
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @package Winaptic
 * @access public
 * @version 1.0
 * @since 2006-09-08
 * {@source } 
 */
 
class WA_apps 
{
    /**
     * @var Integer L'identifiant de l'application
     */
    public $idapps;
    /**
     * @var Integer L'identifiant de la categorie
     */
    public $idcategories;
    /**
     * @var String Le nom de l'application portable
     */
    public $name;
    /**
     * @var String Le nom de l'application d'où provient l'application portable
     */
    public $parent_name;
    /**
     * @var String Nom du fichier représentant le logo en petite taille
     */
    public $logo_small;
    /**
     * @var String Nom du fichier représentant le logo
     */
    public $logo_original;
    /**
     * @var String Nom du site internet de l'application portable
     */
    public $website_name;
    /**
     * @var String Adresse du site internet de l'application portable
     */
    public $website_url;
    /**
     * @var String Nom du site de l'application d'où provient l'application portable
     */
    public $parent_website_name;
    /**
     * @var String Adresse du site de l'application d'où provient l'application portable
     */
    public $parent_website_url;
    /**
     * @var String Adresse de la page présentant l'application d'où provient l'application portable
     */
    public $framasoft_url;
    /**
     * @var Array Tableau contenant les identifiants des licences
     */
    public $licenses;
    /**
     * @var Integer Nombre de licences différentes pour un projet
     */
    public $nb_licenses;
    
    /**
     * Constructeur de la classe. Il initialise toutes les valeurs
     */
    private function __construct() 
    {
        $this->idapps                = 0;
        $this->idcategories          = 1;
        $this->name                  = "";
        $this->parent_name           = "";
        $this->logo_small            = "";
        $this->logo_original         = "";
        $this->website_name          = "";
        $this->website_url           = "";
        $this->parent_website_name   = "";
        $this->parent_website_url    = "";
        $this->framasoft_url         = "";
        $this->licenses              = Array();
        $this->nb_licenses           = 0;
    }
    
    
    /**
     * Fonction permettant de vérifier l'existance d'une licence pour l'application
     * 
     * @param Integer $idlicenses L'identifiant de la licence à vérifier
     * @return Boolean TRUE si la licence existe dans l'application, FALSE sinon
     */
    private function _appsCheckLicenses($idlicenses)
    {
        if ($this->idapps == 0 || $this->nb_licenses == 0) {
            return false;
        }
        
        if (in_array($idlicenses, $this->licenses)) {            
            return true;
        } else {
            return false;
        }
    }
    
    
    /**
     * Fonction permettant d'ajouter une application à la base de données
     * 
     * @access public
     * @return Integer L'identifiant automatique de l'insertion de l'application, FALSE s'il y a une erreur
     */
    public function appsAdd()
    {
        if ($this->idapps != 0) {
            send_error("Error in the function WA_apps->appsAdd(), l'identifiant n'est pas null");
            return false;
        }
        
        $insert_apps = array("categories_iduse"                  => $this->idcategories,
                             "name"                              => $this->name,
                             "parent_name"                       => $this->parent_name,
                             "logo_small"                        => $this->logo_small,
                             "logo_original"                     => $this->logo_original,
                             "website_name"                      => $this->website_name,
                             "website_url"                       => $this->website_url,
                             "parent_website_name"               => $this->parent_website_name,
                             "parent_website_url"                => $this->parent_website_url,
                             "framasoft_url"                     => $this->framasoft_url);
        $result = sql_insert("apps", $insert_apps);
        if ($result === false) {
            send_error("Error in the function WA_apps->appsAdd(), l'insertion de l'application a généré une erreur.");
            return false;
        }
        
        $this->idapps = $result;
        return $result;
    }
    
    
    /**
     * Fonction permettant de mettre à jour l'application
     * 
     * @access public
     * @return Boolean TRUE si la mie à jour s'est bien déroulé, FALSE sinon
     */
    public function appsUpdate()
    {
        if ($this->idapps == 0) {
            send_error("Error in the function WA_apps->appsUpdate(), l'identifiant est null");
            return false;
        }
        
        $update_apps = array("categories_iduse"                  => $this->idcategories,
                             "name"                              => $this->name,
                             "parent_name"                       => $this->parent_name,
                             "logo_small"                        => $this->logo_small,
                             "logo_original"                     => $this->logo_original,
                             "website_name"                      => $this->website_name,
                             "website_url"                       => $this->website_url,
                             "parent_website_name"               => $this->parent_website_name,
                             "parent_website_url"                => $this->parent_website_url,
                             "framasoft_url"                     => $this->framasoft_url);
        $result = sql_update("apps", $update_apps, "idapps=".$this->idapps);
        if ($result === false) {
            send_error("Error in the function WA_apps->appsUpdate(), la mise à jour de l'application a généré une erreur.");
            return false;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant de supprimer une application de la base de données
     * 
     * @return Boolean TRUE si l'application a bien été supprimé, FALSE sinon
     */
    public function appsDelete()
    {
        if ($this->idapps == 0) {
            send_error("Error in the function WA_apps->appsUpdate(), l'identifiant est null");
            return false;
        }
        
        //on supprime d'abord les licences
        $sql_query = "DELETE FROM apps_has_licenses WHERE apps_idapps=".$this->idapps;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_apps->appsDelete(), in the request: '".$sql_query."'
                        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        //on supprime également les releases
        $sql_query = "DELETE FROM releases WHERE apps_idapps=".$this->idapps;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_apps->appsDelete(), in the request: '".$sql_query."'
                        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        //on supprime enfin l'application
        $sql_query = "DELETE FROM apps WHERE idapps=".$this->idapps;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_apps->appsDelete(), in the request: '".$sql_query."'
                        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant de charger en mémoire les données d'une application
     * 
     * @access public
     * @param Integer $idapps L'identifiant de l'application
     * @return Boolean TRUE si l'application a bien été chargé, FALSE sinon
     */
    public function appsCharge($idapps)
    {
        if ($idapps <= 0) {
            send_error("Error in the function WA_apps->appsCharge(), l'identifiant est null");
            return false;
        }
        
        $sql_query = "SELECT *
                      FROM apps
                      WHERE idapps=".$idapps;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_apps->appsCharge(), in the request: '".$sql_query."'
                        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        if (mysql_num_rows($result) > 0) {
            $row = mysql_fetch_assoc($result);
            mysql_free_result($result);
            $this->idapps                = $row["idapps"];
            $this->idcategories          = $row["categories_iduse"];
            $this->name                  = $row["name"];
            $this->parent_name           = $row["parent_name"];
            $this->logo_small            = $row["logo_small"];
            $this->logo_original         = $row["logo_original"];
            $this->website_name          = $row["website_name"];
            $this->website_url           = $row["website_url"];
            $this->parent_website_name   = $row["parent_website_name"];
            $this->parent_website_url    = $row["parent_website_url"];
            $this->framasoft_url         = $row["framasoft_url"];
            
            //chargement des licences
            $this->licenses              = Array();
            $this->nb_licenses           = 0;
            $sql_licence = "SELECT licenses_idlicenses
                            FROM apps_has_licenses
                            WHERE apps_idapps=".$idapps;
            $result_licence = mysql_query($sql_licence);
            if (!$result_licence) {
                send_error("Error in the request: '".$sql_licence."'
                            SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
                return false;
            }
            while ($row_licence = mysql_fetch_assoc($result_licence)) {
                $this->licenses[] = $row_licence["licenses_idlicenses"];
            }
            mysql_free_result($result_licence);
        } else {
            $this->idapps                = 0;
            $this->idcategories          = 1;
            $this->name                  = "";
            $this->parent_name           = "";
            $this->logo_small            = "";
            $this->logo_original         = "";
            $this->website_name          = "";
            $this->website_url           = "";
            $this->parent_website_name   = "";
            $this->parent_website_url    = "";
            $this->framasoft_url         = "";
            $this->licenses              = Array();
            $this->nb_licenses           = 0;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant d'ajouter une licence à l'application
     * 
     * @param Integer $idlicenses L'identifiant de la licence a ajouter à l'application
     * @return Boolean TRUE si la licence a été ajouté, FALSE sinon
     */
    public function appsAddLicenses($idlicenses)
    {
        if ($idlicenses <= 0 || $this->idapps == 0) {
            send_error("Error in the function WA_apps->appsAddLicense(), l'identifiant est null");
            return false;
        }
        
        $insert_licenses = array("apps_idapps"         => $this->idapps,
                                 "licenses_idlicenses" => $idlicenses);
        $result = sql_insert("apps_has_licenses", $insert_licenses, false);
        if ($result === false) {
            send_error("Error in the function WA_apps->appsAddLicense(), l'insertion a echoué");
            return false;
        }
        
        $this->licenses[] = $idlicenses;
        $this->nblicenses++;
        
        return true;
    }
    
    /**
     * Fonction permettant de supprimer une licence à une application
     * 
     * @param Integer $idlicenses L'identifiant de la licenses a supprimer
     * @return Boolean TRUE si la licence a été supprime, FALSE sinon
     * @todo Retirer l'identifiant de licence du tableau
     */
    public function appsDeleteLicenses($idlicenses)
    {
        if (!$this->appsCheckLicenses($idlicenses)) {
            send_error("Error in the function WA_apps->appsDeleteLicenses(), la licence n'existe pas");
            return false;
        }
        
        $sql_query = "DELETE FROM apps_has_licenses WHERE apps_idapps=".$this->idapps." AND licenses_idlicenses=".$idlicenses;
        $result = mysql_query($sql_query);
        if (!$result) {
            send_error("Error in the function WA_apps->appsDeleteLicenses(), in the request: '".$sql_query."'
                        SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
            return false;
        }
        
        $position = array_search($idlicenses, $this->licenses);
        if ($position === false) {
            return true;
        } else {
            unset($this->licenses[$position]);
   	        sort($this->licenses);
   	        $this->nb_licenses--;
        }
        
        return true;
    }
    
    
    /**
     * Fonction permettant d'obtenir le nom de la catégorie à laquelle appartient l'application
     * 
     * @param Integer $idlanguage L'identifiant du langage utilisé (optionnel)
     * @return String Le nom de la catégorie 
     */
    public function appsCategories($idlanguage = 1) {        
        if ($this->idapps == 0) {
            send_error("Error in the function WA_apps->appsCategories(), l'identifiant est null");
            return false;
        }
        
        $return_value = gen_name("categories", $this->idcategories, $idlanguage);
        
        return $return_value;
    }
    
    
    /**
     * Fonction permettant d'obtenir l'intitulé de toutes les licences de l'application
     * 
     * @return String La chaine au format HTML contenant les licences avec leur lien
     */
    public function appsLicenses()
    {
        if ($this->nb_licenses == 0) {
            return "";
        }
        
        $ids = implode(",", $this->licenses);
        $license = "";
        
        $sql_query = "SELECT *
        		      FROM licenses
                      WHERE idlicenses IN (".$ids.")";
        $result = mysql_query($sql_query);
        while ($row = mysql_fetch_assoc($result)) {
            $license .= ($license == "") ? "" : " - ";
            $license .= "<a href=\"".$row["url"]."\">".$row["name"]."</a>";
        }
        
        return $license;
    }
}
?>