<?php
/**
 * Fichier contenant toutes les constantes du projet 
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @access public
 * @version 1.0
 * @since 8-sep-06
 */
 

//---------------- Paramètres du serveur ----------------
/**
 * Adresse du serveur de la base de données
 * @name SERVER
 */
define("SERVER", "localhost");

/**
 * Nom d'utilisateur de la base de données
 * @name LOGIN
 */
define("LOGIN", "root");

/**
 * Mot de passe de la base de données
 * @name PASSWORD
 */
define("PASSWORD", "");

/**
 * Nom de la base de données
 * @name DATABASE
 */
define("DATABASE", "winaptic");

/**
 * Permet de choisir d'effectuer une connexion persistante ou non
 * @name CONN_PERSISTANTE
 */
define("CONN_PERSISTANTE", false);


//---------------- Paramètres spécifique à Winaptic ----------------
/**
 * Nombre de screenshots demandé par défaut lors de l'insertion d'une release
 * @name NB_DEFAULT_SCREENSHOTS
 */
define("NB_DEFAULT_SCREENSHOTS", 4);

/**
 * Nombre de licence demandé par défaut lors de l'insertion d'une application
 * @name NB_DEFAULT_LICENSES
 */
define("NB_DEFAULT_LICENSES", 2);

/**
 * Hauteur de la miniature du screenshots
 * @name SCREEN_HEIGHT
 */
define("SCREEN_HEIGHT", 60);

/**
 * Largeur de la miniaturedu screenshots
 * @name SCREEN_WIDTH
 */
define("SCREEN_WIDTH", 80);

/**
 * Identifiant de la version stable
 * @name STABLE
 */
define("STABLE", 1);

/**
 * Identifiant de la version de développement
 * @name STABLE
 */
define("DEV", 2);

/**
 * Identifiant de la version instable
 * @name UNSTABLE
 */
define("UNSTABLE", 3);

//---------------- Paramètres de DEBUGGAGE ----------------
/**
 * Active le mode de debuggage (affichage d'une page d'erreur) ou non (envoie d'un mail)
 * @name DEBUG_MODE
 */
define("DEBUG_MODE", true);

/**
 * Active l'envoie de l'e-mail au développeur
 * @name DEBUG_SEND
 */
 define("DEBUG_SEND", false);
 
/**
 * Nom du script d'erreur
 * @name ERROR_PAGE
 */
define("ERROR_PAGE", "error.php");

/**
 * Nom du template d'erreur
 * @name TEMPLATE_ERROR
 */
define("TEMPLATE_ERROR", "error.html");

/**
 * Page de retour lors d'une erreur d'indentification
 * @name ERROR_IDENT
 */
define("ERROR_IDENT", "index.php");

/**
 * Sujet pour le mail d'erreur
 * @name SUBJECT_ERROR
 */
define("SUBJECT_ERROR", "Erreur sur le site de winaptic");

/**
 * Adresse e-mail du développeur
 * @name MAIL_DEV
 */
define("MAIL_DEV", "contact@leviathan666.com");


//---------------- Paramètres des dossiers ----------------
/**
 * Adresse du dossier du serveur contenant le site
 * @name ROOT_FOLDER
 */
define("ROOT_FOLDER", "/var/www/winaptic");

/**
 * Adresse du dossier du site contenant les screenshots
 * @name SCREENSHOTS_FOLDER
 */
define("SCREENSHOTS_FOLDER", "images/screenshots/");

/**
 * Adresse du dossier du site contenant les templates
 * @name TEMPLATE_FOLDER
 */
define("TEMPLATE_FOLDER", "templates/");

/**
 * Adresse du dossier du site contenant les templates administrateurs
 * @name TEMPLATE_ADMIN_FOLDER
 */
define("TEMPLATE_ADMIN_FOLDER", "templates/admin/");

/**
 * Adresse du dossier du site contenant les logos
 * @name LOGOS_FOLDER
 */
define("LOGOS_FOLDER", "images/logos/");

/**
 * Adresse du dossier du site contenant les changelogs
 * @name CHANGELOG_FOLDER
 */
define("CHANGELOG_FOLDER", "changelog/");

/**
 * Adresse du dossier contenant les logiciels
 * @name APP_FOLDER
 */
define("APP_FOLDER", "/var/www/winaptic/apps");

//---------------- Paramètres des fichiers ----------------
/**
 * Nom du fichier d'entête
 * @name TEMPLATE_HEADER
 */
define("TEMPLATE_HEADER", "header.html");

/**
 * Nom du fichier de pied de page
 * @name TEMPLATE_FOOTER
 */
define("TEMPLATE_FOOTER", "footer.html");
?>