<?php
/**
 * Fichier contenant toutes les fonctions génériques 
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @access public
 * @version 1.0
 * @since 8-sep-06
 * {@source } 
 */


/**
 * Fonction d'affichage ou d'envoie d'erreur
 * 
 * Cette fonction permet en fonction du paramètre de debuggage:
 * - soit d'envoyer un e-mail avec le message d'erreur au développeur
 * - soit d'afficher un page d'erreur avec le message passé en paramètre
 * 
 * @param String $msg_debug Message de debuggage envoyé ou affiché (pour le développeur)
 * @param String $msg_error Message d'erreur envoyée ou affiché (pour l'utilisateur)
 * @uses DEBUG_MODE
 * @uses DEBUG_SEND
 * @uses MAIL_DEV
 * @uses SUBJECT_ERROR
 * @return Boolean TRUE si tout c'est bien passé, FALSE sinon
 */
function send_error($msg_debug = "Unknow error", $msg_error = "Unknow error")
{
    $result = true;
    if (DEBUG_SEND) {
        $result = @mail(MAIL_DEV, SUBJECT_ERROR, $msg_debug);
    }
    do_html_error($msg_debug, $msg_error);    

    return $result;
}


/**
 * Fonction permettant de se connecter à la base de données
 * 
 * @param String $server Adresse du serveur
 * @param String $login Nom d'utilisateur
 * @param String $password Mot de passe
 * @param String $database Nom de la base de données
 * @uses CONN_PERSISTANTE
 * @return Boolean TRUE si la connexion est effectué, FALSE s'il y a une erreur
 */
function connect_db($server = SERVER, $login = LOGIN, $password = PASSWORD, $database = DATABASE) 
{
    if (CONN_PERSISTANTE) {
        $conn_id = mysql_pconnect($server, $login, $password);
    } else {
        $conn_id = mysql_connect($server, $login, $password);
    }
    if (!$conn_id) {
        send_error("Error connection MySQL server");
        return false;
    }

    $conn_db = mysql_select_db($database, $conn_id);
    if (!$conn_db) {
        send_error("Error connection database");
        return false;
    }

    return true;
}


/**
 * Fonction permettant d'executer une requête de visualisation
 * 
 * @param String $table Nom de la table
 * @param String $fields Nom des champs à sélectionner (optionnel)
 * @param String $where Clause where de la requête (optionnel)
 * @param String $order Clause order by de la requête (optionnel)
 * @param String $group Clause group by de la requête (optionnel)
 * @return Array Un tableau contenant l'ensemble des résultats de la requête, FALSE s'il y a une erreur
 */
function sql_show($table, $fields = "*", $where = "", $order = "", $group  = "") 
{
    $sql_query = "SELECT ".$fields.
                " FROM ".$table;
    $sql_query .= ($where != "") ? " WHERE ".$where : "";
    $sql_query .= ($order != "") ? " ORDER BY ".$order : "";
    $sql_query .= ($group != "") ? " GROUP BY ".$group : "";

    $result = mysql_query($sql_query);
    if (!$result) {
        send_error("Error in the request: '".$sql_query."'
        		    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
    }

    $table_result = array();
    while ($rows = mysql_fetch_array($result)) {
        $table_result[] = $rows;
    }
    mysql_free_result($result);
    
    return $table_result;
}


/**
 * Fonction permettant d'insérer des données dans une table SQL
 * 
 * @param String $table Nom de la table dans laquelle les données seront insérées
 * @param Array $fields_values Un tableau contenant le nom des champs associé à leur valeur à insérer
 * @param Boolean $return_id Demande si l'on doit retouner l'identifiant automatique de l'insertion (optionnel)
 * @return Integer L'identifiant automatique d'insertion, -1 si l'on ne renvoie pas la valeur, false s'il y a une erreur
 */
function sql_insert($table, $fields_values, $return_id = true) 
{
    $sql_query = "INSERT INTO `".$table."`";
    $fields = "";
    $values = "";
    foreach($fields_values as $key => $value) {
        $fields .= ($fields != "") ? ", `".$key."`" : "`".$key."`";
        $values .= ($values != "") ? ", '".$value."'" : "'".$value."'";
    }
    $sql_query = $sql_query." (".$fields.") VALUES (".$values.")";

    $result = mysql_query($sql_query);
    if ( !$result ) {
        send_error("Error in the request: '".$sql_query."'
        		    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
    }

    if ($return_id == true) {
        $id = mysql_insert_id();
    } else {
        $id = -1;
    }
    mysql_free_result($result);
    
    return $id;
}


/**
 * Fonction permettant de mettre à jour les données d'une table
 * 
 * @param String $table Nom de la table à mettre à jour
 * @param Array $fields_values Un tableau contenant le nom des champs associé à leur valeur à mettre à jour
 * @param String $where Clause where de la requête de mise à jour (optionnel)
 * @return Boolean TRUE si la mise à jour s'est bien déroulée, FALSE sinon
 */
function sql_update($table, $fields_values, $where = "")
{
    $sql_query = "UPDATE `".$table."`";
    $fields_update = "";
    foreach($fields_values as $key => $value) {
        $fields_update .= ($fields_update != "") ? ", `".$key."`='".$value."'" : "`".$key."`='".$value."'";
    }
    $sql_query = $sql_query." SET ".$fields_update;
    $sql_query .= ($where != "") ? " WHERE ".$where : "";

    $result = mysql_query($sql_query);
    if (!$result) {
        send_error("Error in the request: '".$sql_query."'
        		    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
    }
    mysql_free_result($result);

    return true;
}


/**
 * Fonction permettant de supprimer un enregistrement d'une table
 * 
 * @param String $table Nom de la table dans laquelle l'enregistrement va être supprimé
 * @param String $where Clause where de la requête de suppression (optionnel)
 */
function sql_delete($table, $where = "")
{
    $sql_query = "DELETE FROM `".$table."`";
    $sql_query .= ($where != "") ? " WHERE ".$where : "";

    $result = mysql_query($sql_query);
    if (!$result) {
        send_error("Error in the request: '".$sql_query."'
        		    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
        exit();
    }
    mysql_free_result($result);

    return true;
}


/**
 * Fonction de gestion des droits
 * 
 * Fonction permettant d'autoriser ou non l'accès à une page en fonction
 * d'un droit. Plus la valeur demandée est base, plus le droit de l'utilisateur doit être élevé
 * 
 * @param Integer $level Niveau de droit requis pour accéder à la page
 * @param String $page La page de redirection en cas de droit insuffisant
 * @return Boolean TRUE si les droits sont suffisant, false sinon
 */
function check_right($level, $page = ERROR_IDENT)
{
    global $_SESSION;

    if (!isset($_SESSION["auth_right"]) || empty($_SESSION["auth_right"])) {
        return false;
        header("Location: ".$page);
        exit();
    }

    if ($level == $_SESSION["auth_right"]) {
        return true;
    } else {
        return false;
        header("Location: ".$page);
        exit();
    }
}


/**
 * Fonction permettant d'obtenir la valeur du champs name d'une table en fonction de l'identifiant
 * 
 * @param String $table Nom de la table dans laquelle on recherche la valeur de name
 * @param Integer $id L'identifiant de la valeur recherchée
 * @param Integer $idlanguage L'identifiant du langage utilisé, -1 s'il n'y a pas de langue
 * @return String La valeur de name ou une chaine vide s'il n'y pas de valeur pour l'identifiant, ou FASLE s'il y a une erreur  
 */
function gen_name($table, $id, $idlanguage = -1)
{
    $sql_query = "SELECT name FROM ".$table." WHERE id".$table."=".$id;
    if ($idlanguage != -1) {
        $sql_query .= " AND languages_idlanguages=".$idlanguage;
    }
    $result = mysql_query($sql_query);
    if(!$result) {
        send_error("Error in the function gen_name with the parameter: table='".$table."' and id='".$id."'\n
                    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
    }
    if (mysql_num_rows($result) > 0) {
        $row = mysql_fetch_array($result);
        mysql_free_result($result);
        return $row["name"];
    } else {
        return "";
    }
}


/**
 * Fonction permettant de générer les listes déroulantes
 * 
 * @param String $table Nom de la table sur laquelle sera basé la liste
 * @param String $id Nom du champs qui servira de valeur à la liste
 * @param String $value Nom du champs qui servira de nom à la liste
 * @param mixed $selected Valeur pour laquelle l'option sera sélectionné (optionnel)
 */
function gen_options($table, $id, $value, $selected=-1)
{
    $sql_query = "SELECT ".$id.", ".$value." FROM ".$table;
    $result = mysql_query($sql_query);
    if(!$result) {
        send_error("Error in the function gen_options with the parameters: table='".$table."', id='".$id."', value='".$value."' and selected='".$selected."'\n
                    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
    }
    
    $return_value = "";
    while ($row = mysql_fetch_array($result)) {
        $return_value .= "<option value=\"".$row[$id]."\"";
        $return_value .= ($selected != -1 && $selected == $row[$id]) ? " selected=\"selected\">" : ">";
        $return_value .= $row[$value]."</option>";
    }
    mysql_free_result($result);
    
    return $return_value;
}


/**
 * Fonction permettant d'associer toutes les variables d'une classe dans un tableau multiple
 *
 * @param Array $array Le tableau dans lequel la classe va être ajoutée
 * @param Class $class La classe qui va être ajoutée au tableau
 */
function class_assoc_multi(&$array, $class)
{
    $class_vars = get_class_vars(get_class($class));
        
    foreach($class_vars as $key => $value) {
        $array[$key][] = $class->$key;
    }
}


/**
 * Fonction permettant d'associer toutes les variables d'une classe dans un tableau
 *
 * @param Array $array Le tableau dans lequel la classe va être ajoutée
 * @param Class $class La classe qui va être ajoutée au tableau
 * @param String $prefixe Le prefixe à mettre avant le nom de la variable de classe (optionnel)
 * @param String $suffixe Le suffixe à mettre après le nom de la variable de classe (optionnel)
 */
function class_assoc(&$array, $class, $prefixe = "", $suffixe = "")
{
    $class_vars = get_class_vars(get_class($class));
        
    foreach($class_vars as $key => $value) {
        $array[$key.$suffixe] = $class->$key;
    }
}


/**
 * Fonction permettant d'uploader un ficher sur le serveur
 * 
 * @param Array $file Tableau contenant les données du fichier uploader
 * @param String $name Nom a donner au fichier sur le serveur
 * @param String $folder Nom du dossier où sera sauvegarder le fichier
 * @return String Le nom du fichier si l'upload s'est bien déroulé, FALSE sinon
 */
function upload($file, $name, $folder)
{
    if ($file["size"] <= 0) {
        send_error("Error in the function upload(). Les fichiers ne peuvent être null!");
        return false;
    }
        
    $extension = strrchr($file["name"], ".");
    if ($extension != ".png" && $extension != ".jpg" && $extension != ".jpeg" && $extension != ".gif") {
        send_error("Error in the function upload(). Les fichiers ne peuvent être que des PNG, JPG ou GIF!");
        return false;
    }
        
    $upload = move_uploaded_file($file["tmp_name"], $folder.$name.$extension);
    if (!$upload) {
        send_error("Error in the function upload(). Erreur lors de l'enregistrement du fichier: '".$name."'!");
        return false;
    }
    
    return $name.$extension;
}


/**
 * Fonction permettant de scanner un répertoire
 * 
 * Elle permet de vérifier q'un dossier existe ien dans un autre dossier
 * et de créer se dossier si neccessaire
 * 
 * @param String $folder_in Nom du dossier que l'on recherche
 * @param String $folder_scan Adresse du dossier dans lequel on recherche le premier dossier
 * @param Integer $droit Droit attribuer au dossier si on le crée
 * @return Boolean TRUE si le dossier est présent ou a été créé, FALSE sinon
 */
function scan_folder($folder_in, $folder_scan, $droit = 0644)
{
    $folder = scandir($folder_scan);
    if (in_array($folder_in, $folder)) {
        if (!is_dir($folder_in)) {
            $result = mkdir($folder_in, $droit);
            if (!$result) {
                send_error("Error in the function scan_folder(), la création du dossier '".$folder_in."' a échoué");
                return false;
            }
        }
    } else {
        $result = mkdir($folder_in, $droit);
        if (!$result) {
            send_error("Error in the function scan_folder(), la création du dossier ".$folder_in." a échoué");
            return false;
        }
    }
}
?>