<?php
/**
 * Fichier contenant toutes les fonctions en rapport avec l'affichage de partie du site
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @access public
 * @version 1.0
 * @since 9-sep-06
 * {@source } 
 */


/**
 * Fonction permettant d'afficher l'entête du fichier
 * 
 * @param String $title Titre de la page (optionnel)
 * @param String $meta_keywords Mot clé pour la page (optionnel)
 * @param String $meta_description Description pour la page (optionnel)
 * @param String $template_file Nom du fichier d'entête (optionnel)
 */
function do_html_header($title = '', $meta_keywords = '', $meta_description = '', $template_file = TEMPLATE_HEADER) 
{
    $subst["title"] = $title;
    $subst["meta_keywords"] = $meta_keywords;
    $subst["meta_description"] = $meta_description;    
    
    echo tpl_parse_file(TEMPLATE_FOLDER.$template_file, $subst);
}


/**
 * Fonction permettant d'afficher l'entête du fichier de la partie administration
 * 
 * @param String $title Titre de la page (optionnel)
 * @param String $template_file Nom du fichier d'entête (optionnel)
 */
function do_html_admin_header($title = '', $template_file = TEMPLATE_HEADER) 
{
    $subst["title"] = $title;  
    
    echo tpl_parse_file(TEMPLATE_ADMIN_FOLDER.$template_file, $subst);
}


/**
 * Fonction permettant d'afficher le pied de page du fichier
 * 
 * @param String $template_file Nom du fichier de pied de page (optionnel)
 */
function do_html_footer($template_file = TEMPLATE_FOOTER) 
{
    $subst = array();
    echo tpl_parse_file(TEMPLATE_FOLDER.$template_file, $subst);
}


/**
 * Fonction permettant d'afficher le pied de page du fichier de la partie administration
 * 
 * @param String $template_file Nom du fichier de pied de page (optionnel)
 */
function do_html_admin_footer($template_file = TEMPLATE_FOOTER) 
{
    $subst = array();
    echo tpl_parse_file(TEMPLATE_ADMIN_FOLDER.$template_file, $subst);
}


/**
 * Fonction permettant d'afficher la page d'erreur
 * 
 * @param String $msg_debug Message de debuggage à l'attention du développeur
 * @param String $msg_error Message d'erreur à l'attention de l'utilisateur
 * @param String $template_file Nom du fichier de template pour afficher l'erreur
 */
function do_html_error($msg_debug = "", $msg_error = "", $template_file = TEMPLATE_ERROR) 
{
    $subst = array();
    if (DEBUG_MODE) {
        $subst["error"] = $msg_debug;
    } else {
        $subst["error"] = ($msg_error != "") ? $msg_error : $msg_debug;
    }    
    
    echo tpl_parse_file(TEMPLATE_FOLDER.$template_file ,$subst);
}
?>