<?php
/**
 * Fichier contenant les fonctions relatives au moteur de templates
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @access public
 * @version 1.0
 * @since 9-sep-06
 * {@source } 
 */


/**
 * Fonction récursive de transformation de template
 * 
 * Cette fonction permet de manière récursive de transformer les variables,
 * les boucles, ... dans le fichier de templates. C'est la coeur du moteur de templates
 * 
 * @param Array $subst Un tableau associatif contenant les noms et valeurs des variables à remplacer
 * @param String $template Le texte du fichier dans lequel on remplace les variables
 * @return String La chaine contenant le template avec les variables remplacé
 */
function boucle_tpl($subst, &$template)
{
    foreach( $subst as $key => $value ) {
        if( !is_array( $value ) ) {
            if( $value == '#null#' ) {
                $begin_pos = strpos($template, "<!--$key#begin-->");
                $end_pos = strpos($template, "<!--$key#end-->");
                $tpl_length = $end_pos - $begin_pos;
                $tpl_string = substr($template ,$begin_pos ,$tpl_length);
                $template = str_replace($tpl_string, "", $template);
            } else {
                $template = str_replace("%$key%", "$value", $template);
            }
        } else {
            $begin_pos = strpos($template, "<!--$key#begin-->");
            $end_pos = strpos($template, "<!--$key#end-->");
            $tpl_length = $end_pos - $begin_pos;
            $tpl_string = substr($template, $begin_pos, $tpl_length);
            $tpl_string = str_replace("<!--$key#begin-->", "", $tpl_string );
            $var_names = array_keys($value);
            $line_count = count($value[$var_names[0]]);
            $tpl_replace = "";
            for($i = 0; $i < $line_count; $i++) {
                $tmp_string = $tpl_string;
                foreach($var_names as $v_name){
                    if(!is_array($value[$v_name][$i])) {
                        $tmp_string = str_replace("%$v_name%", $value[$v_name][$i], $tmp_string);
                    } else {
                        $tmp_string = boucle_fns($value[$v_name][$i], $tmp_string);
                    }
                }
                $tpl_replace .= $tmp_string;
            }
            $to_replace = "<!--$key#begin-->" . $tpl_string . "<!--$key#end-->";
            $template = str_replace($to_replace, $tpl_replace, $template);
        }
    }
}


/**
 * Fonction permettant la gestion des conditions à l'intérieur des templates
 * 
 * @param Array $subst Un tableau associatif contenant les noms et valeurs des variables à remplacer
 * @param String $template Le texte du fichier dans lequel on remplace les variables
 * @return String La chaine contenant le template avec les variables remplacé
 */
function condition_tpl($subst, &$template)
{
    while (true) {
        $open_tag_pos = strpos($template, "<%tpl");
        if (is_bool($open_tag_pos) && !$open_tag_pos) {
            break;
        }
        $close_tag_pos = strpos($template, "%>");
        $tpl_length = $close_tag_pos - $open_tag_pos;
        $tpl_string = substr($template, $open_tag_pos, $tpl_length + 2);
        $to_replace = $tpl_string;
        $tpl_string = str_replace("<%tpl", "", $tpl_string);
        $tpl_string = str_replace("%>", "", $tpl_string);
        $tpl_string = trim($tpl_string);

        preg_match("/\(( )*(.)*=(.)*\)/", $tpl_string, $condition);
        $condition = $condition[0];
        $trans = array("(" => "", ")" => "");
        $condition = strtr($condition, $trans);
        $variable = split("=", $condition);
        $variable[0] = trim($variable[0]);
        $variable[1] = trim($variable[1]);
        $if_case = false;
        if((isset($subst[$variable[0]]) && $subst[$variable[0]] == $variable[1]) || ($variable[0] == $variable[1])) $if_case = true;

        if($if_case) preg_match("/\{.*\}.*(?=else)/s", $tpl_string, $condition);
        else preg_match("/(?=else).*\{.*\}/s", $tpl_string, $condition);

        $condition = $condition[0];
        $condition = str_replace("else", "", $condition);
        $condition = trim($condition);
        $trans = array("{" => "", "}" => "");
        $condition = strtr($condition, $trans);
        $template = str_replace($to_replace, $condition, $template);
    }
}


/**
 * Fonction permettant de générer le template
 * 
 * @param String $filename Nom du fichier servant de template
 * @param Array $subst Un tableau associatif contenant les noms et valeurs des variables à remplacer
 * @return String Le fichier de template avec les variables remplacées
 */
function tpl_parse_file($filename, $subst)
{
    //on ouvre le fichier template
    $handle = fopen($filename, "r");
    $template = fread($handle, filesize($filename));

    //on remplace les variables
    boucle_tpl($subst, $template);
    
    //on remplace les conditions
    condition_tpl($subst, $template);
    
    //on ferme le fichier template
    fclose($handle);

    //on renvoie les données
    return $template;
}
?>