<?php
/**
 * Fichier contenant les fonctions relatives à Winaptic
 *
 * @author Leblanc Simon <contact@leblanc-simon.eu>
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @access public
 * @version 1.0
 * @since 10-sep-06
 * {@source } 
 */


/**
 * Fonction permettant de trouver le nom du screenshots à insérer
 * 
 * @param Integer $idrelease Identifiant de la release
 * $result Integer Numéro du screnshot, FALSE s'il y a une erreur
 */
function screenshots_name($idrelease)
{
    $sql_query = "SELECT original_url
                  FROM releases_has_screenshots
                  WHERE releases_idreleases=".$idrelease."
                  ORDER BY original_url";
    $result = mysql_query($sql_query);
    if (!$result) {
        send_error("Error in the function WA_releases->releasesDelete(), in the request: '".$sql_query."'
                    SQL Error:'".mysql_error()."' Page:'".$_SERVER[ 'PHP_SELF' ]."' / '".$_SERVER["REQUEST_URI"]."'");
        return false;
    }
    $i = 0;
    $trouve = false;
    while ($row = mysql_fetch_array($result)) {
        $i++;
        $url = $row["original_url"];
        $position_scr = strpos("_screenshot", $url);
        $position_poi = strrpos(".", $url);
        $num = substr($url, $position_scr + 11, strlen($url) - $position_poi);
        if ($num != $i) {
            $return_value = $num;
            $trouve = false;
            break 1;
        }
    }
    
    if ($i == 0) {
        $return_value = 1;
    }
    if ($trouve == false) {
        $return_value = $i + 1;
    }
    
    return $return_value;
}


/**
 * Fonction permettant de créer la miniature du screenshot
 * 
 * @param String $original Nom du screenshot original
 * @param String $folder Adresse du dossier où sera stocké la miniature
 * @param Integer $width Largeur de la miniature (optionnel)
 * @param Integer $height Hauteur de la miniature (optionnel)
 * @return String Nom de la miniature du screenshot, FALSE s'il y a un problème
 */
function screenshots_small($original, $folder, $width = SCREEN_WIDTH, $height = SCREEN_HEIGHT)
{
    //on ouvre le fichier original du screenshot
    if (!file_exists($folder.$original)) {
        if (!fopen($folder.$original, "xb")) {
            send_error("Error in the function 'screenshots_small', the picture '".$original."' doesn't exist and faile to create.\n
                        Page:'".$_SERVER[ 'PHP_SELF' ]."'");
            return false;
        }
    }
    
    //ouverture de l'image et calcul des hauteurs
    $image_src = imagecreatefromjpeg($folder.$original);
    $image_dest = imagecreatetruecolor($width, $height);
    $width_src = imagesx($image_src);
	$height_src = imagesy($image_src);
	
	//création du nom de la miniature du screenshot
	$extension = strrchr($original, ".");
	$position_scr = strpos("_screenshot", $original);
	$position_poi = strrpos(".", $original);
	$num_screen = substr($original,$position_scr + 11, strlen($original) - $position_poi);
	$name = substr($original, 0, $position_scr + 11)."_small".$num_screen.$extension;
	
	//création de la miniature sur le serveur
    if (!imagecopyresampled($image_dest, $image_src, 0, 0, 0, 0, $width, $height, $width_src, $height_src)) {
        send_error("Error in the function 'screenshots_small', the picture '".$name."' isn't resized.\n
                    Page:'".$_SERVER[ 'PHP_SELF' ]."'");
        return false;
    }
    imagejpeg($image_dest,$folder.$name);
    
    return $name;
}
?>